/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.analytics.model;

import android.content.Context;
import android.util.Log;
import com.ainirobot.base.analytics.model.Event;
import com.ainirobot.base.analytics.model.FileData;
import com.ainirobot.base.analytics.model.FileDataManager;
import com.ainirobot.base.analytics.model.IAnalyticsBatchCache;
import com.ainirobot.base.util.Logger;
import java.util.List;
import org.json.JSONObject;

public class AnalyticsFileCache
implements IAnalyticsBatchCache<Event> {
    private FileDataManager mFileDataManager;

    public AnalyticsFileCache(Context context) {
        this.mFileDataManager = new FileDataManager(context);
    }

    @Override
    public void putAll(List<Event> bundles) {
        for (Event event : bundles) {
            this.mFileDataManager.saveCache(event);
        }
    }

    @Override
    public void put(Event bundle) {
        if (bundle == null) {
            return;
        }
        boolean save = this.mFileDataManager.saveCache(bundle);
        Log.i((String)"OBAnalytics", (String)("ForceReport fail table_name = " + bundle.getContent() + " saved file = " + save));
    }

    @Override
    public List<JSONObject> getAll() {
        return this.mFileDataManager.getAll();
    }

    @Override
    public FileData getCountFile(int count) {
        return this.mFileDataManager.getCountFile(count);
    }

    @Override
    public void clearExpired() {
        this.mFileDataManager.removeOvermuchCache();
        if (Logger.debuggable()) {
            Logger.d("OBAnalytics", "clearExpired........");
        }
    }

    @Override
    public void delete() {
        this.mFileDataManager.delete();
        if (Logger.debuggable()) {
            Logger.d("OBAnalytics", "report batch success, delete file ........");
        }
    }

    @Override
    public void deleteCountFile(List<String> files) {
        if (files == null || files.isEmpty()) {
            return;
        }
        this.mFileDataManager.delete(files);
        if (Logger.debuggable()) {
            Logger.d("OBAnalytics", "report batch success, delete part file ........");
        }
    }
}

