/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.analytics.model;

import android.content.Context;
import com.ainirobot.base.analytics.model.AnalyticsFileCache;
import com.ainirobot.base.analytics.model.Event;
import com.ainirobot.base.analytics.model.FileData;
import com.ainirobot.base.analytics.utils.PublicDataUtils;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public final class AnalyticsDataManager {
    private AnalyticsFileCache mAnalyticsFileCache;

    private AnalyticsDataManager() {
    }

    public static AnalyticsDataManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public synchronized void init(Context context) {
        if (this.mAnalyticsFileCache == null) {
            this.mAnalyticsFileCache = new AnalyticsFileCache(context);
        }
    }

    public long put(List<Event> events) {
        if (events != null && events.size() > 0) {
            this.mAnalyticsFileCache.putAll(events);
        }
        return 0L;
    }

    public long put(Event event) {
        if (event != null) {
            this.mAnalyticsFileCache.put(event);
        }
        return 0L;
    }

    public void delete() {
        this.mAnalyticsFileCache.delete();
    }

    public synchronized void deleteCountFile(List<String> fileNames) {
        if (fileNames == null || fileNames.isEmpty()) {
            return;
        }
        this.mAnalyticsFileCache.deleteCountFile(fileNames);
    }

    public synchronized void deleteExpired() {
        this.mAnalyticsFileCache.clearExpired();
    }

    public String getAll() {
        JSONObject json;
        List<JSONObject> jsonObjects = this.mAnalyticsFileCache.getAll();
        if (jsonObjects == null || jsonObjects.size() == 0) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        for (JSONObject value : jsonObjects) {
            jsonArray.put((Object)value);
        }
        try {
            json = PublicDataUtils.getPublicDataJson();
            json.put("business_field", (Object)jsonArray);
        }
        catch (Exception e) {
            return null;
        }
        JSONArray resultJSONArray = new JSONArray();
        resultJSONArray.put((Object)json);
        return resultJSONArray.toString();
    }

    public FileData getCountFile(int count) {
        FileData fileData = this.mAnalyticsFileCache.getCountFile(count);
        return fileData;
    }

    public synchronized String get(Event event) {
        JSONObject json;
        try {
            JSONObject jsonObject = new JSONObject(event.getContent());
            JSONArray jsonArray = new JSONArray();
            jsonArray.put((Object)jsonObject);
            json = PublicDataUtils.getPublicDataJson();
            json.put("business_field", (Object)jsonArray);
        }
        catch (Exception e) {
            return null;
        }
        JSONArray resultJSONArray = new JSONArray();
        resultJSONArray.put((Object)json);
        return resultJSONArray.toString();
    }

    private static class SingletonHolder {
        private static final AnalyticsDataManager INSTANCE = new AnalyticsDataManager();

        private SingletonHolder() {
        }
    }
}

