/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.analytics.controller;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.util.Log;
import com.ainirobot.base.AnalyticsConfig;
import com.ainirobot.base.analytics.interfaces.OnReportResultListener;
import com.ainirobot.base.analytics.model.AnalyticsDataManager;
import com.ainirobot.base.analytics.model.Event;
import com.ainirobot.base.analytics.model.FileData;
import com.ainirobot.base.analytics.utils.AnalyticsSpiCall;
import com.ainirobot.base.analytics.utils.KSupportUtil;
import com.ainirobot.base.network.DefaultHttpRequestFactory;
import com.ainirobot.base.util.Logger;
import org.json.JSONObject;

final class AnalyticsReportManager {
    private PendingIntent mPI;
    private Handler mHandler;
    private HandlerThread mHandlerThread;
    private Context mContext;
    private static final String TIMER_ACTION = "analytics.Timer";
    private AlarmManager mAlarm;
    private OnReportResultListener mOnReportResultListener;
    private static final String TAG = "AnalyticsReportManager";

    public AnalyticsReportManager(Context context, OnReportResultListener onReportResultListener) {
        this.mContext = context;
        this.mOnReportResultListener = onReportResultListener;
        AnalyticsDataManager.getInstance().init(this.mContext);
        this.mHandlerThread = new HandlerThread("analytics.handler.thread");
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        this.timerReport(AnalyticsConfig.TIMING_REPORT_INTERVAL);
    }

    private void timerReport(final Long delayTime) {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                FileData fileData = AnalyticsDataManager.getInstance().getCountFile(6000);
                if (!AnalyticsReportManager.this.reportBatchFile(fileData)) {
                    AnalyticsReportManager.this.reportBatchFile(fileData);
                }
                AnalyticsReportManager.this.timerReport(delayTime);
            }
        }, delayTime.longValue());
    }

    public void report(Event event) {
        if (event == null) {
            return;
        }
        if (event.isForceReport()) {
            this.forceReport(event);
        } else {
            AnalyticsDataManager.getInstance().deleteExpired();
            AnalyticsDataManager.getInstance().put(event);
        }
    }

    private boolean forceReport(Event event) {
        if (!KSupportUtil.isNetworkActive(this.mContext)) {
            AnalyticsDataManager.getInstance().put(event);
            return false;
        }
        String postData = AnalyticsDataManager.getInstance().get(event);
        boolean reportResult = this.doReport(postData);
        if (!reportResult) {
            AnalyticsDataManager.getInstance().put(event);
        }
        return reportResult;
    }

    private boolean reportBatchFile(FileData fileData) {
        if (fileData == null) {
            return true;
        }
        if (!KSupportUtil.isNetworkActive(this.mContext)) {
            return false;
        }
        String postString = fileData.getDataString();
        Log.i((String)TAG, (String)"reportBatchFile \uff01\uff01\uff01 ");
        boolean reportResult = this.doReport(postString);
        if (reportResult) {
            AnalyticsDataManager.getInstance().deleteCountFile(fileData.fileNames);
        }
        return reportResult;
    }

    private boolean doReport(String postData) {
        if (TextUtils.isEmpty((CharSequence)postData)) {
            return true;
        }
        Log.i((String)TAG, (String)("postData = " + postData));
        try {
            DefaultHttpRequestFactory httpRequestFactory = new DefaultHttpRequestFactory();
            AnalyticsSpiCall spiCall = new AnalyticsSpiCall(AnalyticsConfig.getReportUrl(), httpRequestFactory);
            JSONObject responseJsonObject = spiCall.invoke(postData);
            if (responseJsonObject.getInt("code") == 200) {
                this.mOnReportResultListener.onReportSuccess(postData, responseJsonObject);
                if (Logger.debuggable()) {
                    Logger.d("OBAnalytics", "onReportSuccess........");
                }
            } else {
                this.mOnReportResultListener.onReportFail(postData, responseJsonObject);
                if (Logger.debuggable()) {
                    Logger.d("OBAnalytics", "onReportFail........");
                }
            }
            return true;
        }
        catch (Exception e) {
            if (Logger.debuggable()) {
                Logger.d("OBAnalytics", "Upload failed!!! ........");
            }
            this.mOnReportResultListener.onReportException(postData, e.getMessage());
            return false;
        }
    }
}

