/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.analytics.controller;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.ainirobot.base.analytics.controller.AnalyticsReportManager;
import com.ainirobot.base.analytics.interfaces.IAnalyticsConsumer;
import com.ainirobot.base.analytics.interfaces.OnReportResultListener;
import com.ainirobot.base.analytics.model.Event;
import com.ainirobot.base.util.Logger;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public final class AnalyticsController
implements OnReportResultListener,
IAnalyticsConsumer {
    private final AnalyticsReportManager mAnalyticsReportManager;
    private Context mContext;
    private OnReportResultListener mOnReportResultListener;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private ThreadPoolExecutor mThreadPoolExecutor;
    private static final String TAG = "AnalyticsController";

    public AnalyticsController(Context context) {
        this.mContext = context.getApplicationContext();
        this.mAnalyticsReportManager = new AnalyticsReportManager(this.mContext, this);
        this.mThreadPoolExecutor = new ThreadPoolExecutor(8, 8, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    public void consumeEvent(final Event event) {
        if (event == null) {
            return;
        }
        this.mThreadPoolExecutor.execute(new Runnable(){

            @Override
            public void run() {
                AnalyticsController.this.mAnalyticsReportManager.report(event);
            }
        });
    }

    public void addEvent(String tableName, String dataString, boolean isForce) {
        if (TextUtils.isEmpty((CharSequence)tableName) || dataString == null) {
            return;
        }
        Event event = new Event.Builder().tableName(tableName).dataString(dataString).forceReport(isForce).create();
        this.consumeEvent(event);
    }

    public void addEvent(String tableName, Bundle bundle, boolean isForce) {
        if (TextUtils.isEmpty((CharSequence)tableName) || bundle == null) {
            return;
        }
        Event event = new Event.Builder().tableName(tableName).bundle(bundle).forceReport(isForce).create();
        this.consumeEvent(event);
    }

    @Override
    public void onReportSuccess(final String requestData, final JSONObject jsonObject) {
        if (Logger.debuggable()) {
            Logger.d("OBAnalytics", "onReportSuccess : " + requestData);
        }
        if (this.mOnReportResultListener == null) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                AnalyticsController.this.mOnReportResultListener.onReportSuccess(requestData, jsonObject);
            }
        });
    }

    @Override
    public void onReportException(final String requestData, final String msg) {
        if (Logger.debuggable()) {
            Logger.d("OBAnalytics", "onReportException : " + msg);
        }
        if (this.mOnReportResultListener == null) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                AnalyticsController.this.mOnReportResultListener.onReportException(requestData, msg);
            }
        });
    }

    @Override
    public void onReportFail(final String requestData, final JSONObject jsonObject) {
        if (Logger.debuggable()) {
            Logger.d("OBAnalytics", "onReportFail : " + jsonObject.toString());
        }
        if (this.mOnReportResultListener == null) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                AnalyticsController.this.mOnReportResultListener.onReportFail(requestData, jsonObject);
            }
        });
    }

    public void setOnReportResultListener(OnReportResultListener onReportResultListener) {
        this.mOnReportResultListener = onReportResultListener;
    }
}

