/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.ainirobot.base.DropBoxPluginHandler;
import com.ainirobot.base.OrionBaseCore;
import com.ainirobot.base.PerformancePluginHandler;
import com.ainirobot.base.config.Constants;
import com.ainirobot.base.config.CustomConfig;
import com.ainirobot.base.config.WarnConfig;
import com.ainirobot.base.cpumemory.CPUFreTempMonitorClient;
import com.ainirobot.base.cpumemory.CPUMemoryCanaryPlugin;
import com.ainirobot.base.dropbox.DropBoxPlugin;
import com.ainirobot.base.listener.ICpuFreMonitorListener;
import com.ainirobot.base.listener.ICpuWarnListener;
import com.ainirobot.base.listener.IMemoryWarnListener;
import com.ainirobot.base.listener.ITempMonitorListener;
import com.ainirobot.base.plugin.Plugin;
import com.ainirobot.base.trace.TracePlugin;
import com.ainirobot.base.upload.UploadManager;
import com.ainirobot.base.util.LocalUtils;
import com.ainirobot.base.util.Logger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

class OrionBaseInternal {
    static CustomConfig mConfig;
    private static final List<Runnable> myDeferredActions;

    OrionBaseInternal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void startProcess(Context context) {
        if (!OrionBaseCore.isInitialized()) {
            ArrayList<Runnable> actions;
            OrionBaseInternal.checkConfigNotNull();
            Context applicationContext = context.getApplicationContext();
            UploadManager.with(applicationContext);
            PerformancePluginHandler performancePluginHandler = new PerformancePluginHandler(applicationContext);
            OrionBaseCore.Builder builder = new OrionBaseCore.Builder(applicationContext).plugin(new CPUMemoryCanaryPlugin(mConfig).setPluginHandler(performancePluginHandler)).plugin(new DropBoxPlugin().setPluginHandler(new DropBoxPluginHandler()));
            builder.build();
            OrionBaseCore.singleton().startAllPlugins();
            List<Runnable> list = myDeferredActions;
            synchronized (list) {
                actions = new ArrayList<Runnable>(myDeferredActions);
                myDeferredActions.clear();
            }
            for (Runnable a : actions) {
                a.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void start(Context context, String clientId) {
        if (!OrionBaseCore.isInitialized()) {
            ArrayList<Runnable> actions;
            OrionBaseInternal.checkConfigNotNull();
            Context applicationContext = context.getApplicationContext();
            UploadManager.with(applicationContext);
            PerformancePluginHandler performancePluginHandler = new PerformancePluginHandler(applicationContext);
            OrionBaseCore.Builder builder = new OrionBaseCore.Builder(applicationContext).clientId(clientId).plugin(new TracePlugin(mConfig).setPluginHandler(performancePluginHandler)).plugin(new CPUMemoryCanaryPlugin(mConfig));
            builder.build();
            OrionBaseCore.singleton().startAllPlugins();
            List<Runnable> list = myDeferredActions;
            synchronized (list) {
                actions = new ArrayList<Runnable>(myDeferredActions);
                myDeferredActions.clear();
            }
            for (Runnable a : actions) {
                a.run();
            }
        }
    }

    static void startCpuFreTempMonitor(Context context) {
        CPUFreTempMonitorClient.getInstance().start(context);
    }

    static void setCpuFreMonitor(ICpuFreMonitorListener cpuFreMonitorListener) {
        CPUFreTempMonitorClient.getInstance().setCpuFreMonitorListener(cpuFreMonitorListener);
    }

    static void setTempMonitor(ITempMonitorListener tempMonitorListener) {
        CPUFreTempMonitorClient.getInstance().setTempMonitorListener(tempMonitorListener);
    }

    static void setProcessName(String processName) {
        OrionBaseInternal.checkConfigNotNull();
        mConfig.setProcessName(processName);
    }

    public static void setMemoryWarnConfigs(List<WarnConfig> configs) {
        OrionBaseInternal.checkConfigNotNull();
        mConfig.setMemoryWarnConfigs(configs);
    }

    public static void setCpuWarnConfigs(List<WarnConfig> configs) {
        OrionBaseInternal.checkConfigNotNull();
        mConfig.setCpuWarnConfigs(configs);
    }

    public static void setProcessNames(List<String> processNames) {
        OrionBaseInternal.checkConfigNotNull();
        mConfig.setProcessNames(processNames);
    }

    static void setMemoryWarnThreshold(int[] memoryWarnThreshold) {
        OrionBaseInternal.checkConfigNotNull();
        mConfig.setMemoryWarnThreshold(memoryWarnThreshold);
    }

    static void setCpuWarnThreshold(int[] cpuWarnThreshold) {
        OrionBaseInternal.checkConfigNotNull();
        mConfig.setCpuWarnThreshold(cpuWarnThreshold);
    }

    static void setWarnSampleRate(long warnSampleRate) {
        OrionBaseInternal.checkConfigNotNull();
        mConfig.setWarnSampleRate(warnSampleRate);
    }

    static void setWarnSampleCount(int warnSampleCount) {
        OrionBaseInternal.checkConfigNotNull();
        mConfig.setWarnSampleCount(warnSampleCount);
    }

    static void checkConfigNotNull() {
        if (mConfig == null) {
            mConfig = new CustomConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runOnConnect(Runnable runnable) {
        if (OrionBaseInternal.isInitialized()) {
            runnable.run();
        } else {
            List<Runnable> list = myDeferredActions;
            synchronized (list) {
                myDeferredActions.add(runnable);
            }
        }
    }

    static void setCpuWarnListener(final ICpuWarnListener icpuWarnListener) {
        OrionBaseInternal.runOnConnect(new Runnable(){

            @Override
            public void run() {
                CPUMemoryCanaryPlugin plugin = OrionBaseCore.singleton().getPluginByClass(CPUMemoryCanaryPlugin.class);
                if (plugin != null) {
                    plugin.setCpuWarningListener(icpuWarnListener);
                }
            }
        });
    }

    static void setMemoryWarnListener(final IMemoryWarnListener memoryWarnListener) {
        OrionBaseInternal.runOnConnect(new Runnable(){

            @Override
            public void run() {
                CPUMemoryCanaryPlugin plugin = OrionBaseCore.singleton().getPluginByClass(CPUMemoryCanaryPlugin.class);
                if (plugin != null) {
                    plugin.setMemoryWarningListener(memoryWarnListener);
                }
            }
        });
    }

    static void resetCPUMemoryWarnCount() {
        OrionBaseInternal.runOnConnect(new Runnable(){

            @Override
            public void run() {
                CPUMemoryCanaryPlugin plugin = OrionBaseCore.singleton().getPluginByClass(CPUMemoryCanaryPlugin.class);
                if (plugin != null) {
                    plugin.resetCPUMemoryWarnCount();
                }
            }
        });
    }

    static void cleanCpuMemoryConfig() {
        OrionBaseInternal.runOnConnect(new Runnable(){

            @Override
            public void run() {
                CPUMemoryCanaryPlugin plugin = OrionBaseCore.singleton().getPluginByClass(CPUMemoryCanaryPlugin.class);
                if (plugin != null) {
                    plugin.cleanCpuMemoryConfig();
                    mConfig.setCpuWarnConfigs(null);
                    mConfig.setMemoryWarnConfigs(null);
                    mConfig.setProcessName(null);
                    mConfig.setProcessNames(null);
                    mConfig.setMemoryWarnThreshold(null);
                    mConfig.setCpuWarnThreshold(null);
                    mConfig.setWarnSampleCount(-1);
                    mConfig.setWarnSampleRate(-1L);
                }
            }
        });
    }

    static boolean isInitialized() {
        return OrionBaseCore.isInitialized();
    }

    static void setDebuggable(boolean debuggable) {
        Logger.setDebuggable(debuggable);
    }

    static void setJsRole(String jsRole) {
        LocalUtils.setJsRole(jsRole);
    }

    static void setJsScene(String jsScene) {
        LocalUtils.setJsScene(jsScene);
    }

    static String getJsRole() {
        return LocalUtils.getJsRole();
    }

    static String getJsScene() {
        return LocalUtils.getJsScene();
    }

    static void setAppPackageName(String packageName) {
        LocalUtils.setPackageName(packageName);
    }

    static String getAppPackageName(Context context) {
        return LocalUtils.getPackageName(context);
    }

    static void setAppName(String name) {
        LocalUtils.setAppName(name);
    }

    static String getAppName(Context context) {
        return LocalUtils.getAppName(context);
    }

    static void setAppVersion(String version) {
        LocalUtils.setAppVersion(version);
    }

    static String getAppVersion(Context context) {
        return LocalUtils.getVersionCode(context);
    }

    static void setOptJson(String jsonString) {
        LocalUtils.setOptJson(jsonString);
    }

    static String getOptJson() {
        return LocalUtils.getOptJson();
    }

    static void logApi(int type, String action, String msg, Bundle extras) {
    }

    static void logCrash(Throwable throwable, Bundle extras) {
        if (throwable == null) {
            return;
        }
        UploadManager.logCrash(throwable, extras);
    }

    static void logNativeCrash(Bundle extras) {
        UploadManager.logNativeCrash(extras);
    }

    static Plugin getPluginByClass(Class pluginClass) {
        return OrionBaseCore.singleton().getPluginByClass(pluginClass);
    }

    static void setModel(String model) {
        LocalUtils.setModel(model);
    }

    static void setChannelNumber(String channelNumber) {
        LocalUtils.setChannelNumber(channelNumber);
    }

    static void setDomainEnv(boolean globalMode, String zone, boolean devMode) {
        Log.d((String)"OrionBaseSDK", (String)("global= " + globalMode + ", dev= " + devMode + ", zone= " + zone));
        Constants.ENABLE_DOMAIN_GLOBAL = globalMode;
        Constants.BUILD_TYPE_UNIT_TEST = devMode;
        Constants.GLOBAL_ZONE = zone;
        if (devMode) {
            OrionBaseInternal.setDebuggable(true);
        }
        if (globalMode) {
            Constants.processServerZoneData();
        }
    }

    static {
        myDeferredActions = new LinkedList<Runnable>();
    }
}

