/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base;

import android.content.Context;
import com.ainirobot.base.ApplicationWrapper;
import com.ainirobot.base.DefaultPluginListener;
import com.ainirobot.base.plugin.Plugin;
import com.ainirobot.base.util.LocalUtils;
import com.ainirobot.base.util.Logger;
import java.util.concurrent.ConcurrentLinkedQueue;

class OrionBaseCore {
    private static volatile OrionBaseCore sInstance;
    private ConcurrentLinkedQueue<Plugin> plugins;

    private OrionBaseCore(Context context) {
        ApplicationWrapper.setApplicationContext(context);
    }

    private void build(ConcurrentLinkedQueue<Plugin> plugins) {
        Context context = ApplicationWrapper.getApplicationContext();
        DefaultPluginListener listener = new DefaultPluginListener();
        this.plugins = plugins;
        for (Plugin plugin : plugins) {
            plugin.init(context, listener);
            listener.onInit(plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isInitialized() {
        Class<OrionBaseCore> clazz = OrionBaseCore.class;
        synchronized (OrionBaseCore.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init(OrionBaseCore orionBaseCore) {
        if (orionBaseCore == null) {
            if (Logger.debuggable()) {
                throw new RuntimeException("OrionBase init, OrionBase should not be null.");
            }
            Logger.e("OrionBase init, OrionBase should not be null.", new Object[0]);
        }
        Class<OrionBaseCore> clazz = OrionBaseCore.class;
        synchronized (OrionBaseCore.class) {
            if (sInstance == null) {
                sInstance = orionBaseCore;
                LocalUtils.init();
            } else {
                Logger.e("OrionBaseCore instance is already set. this invoking will be ignored", new Object[0]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static OrionBaseCore singleton() {
        if (sInstance == null) {
            if (Logger.debuggable()) {
                throw new RuntimeException("you must init OrionBaseCore sdk first");
            }
            Logger.e("you must init OrionBaseCore sdk first", new Object[0]);
        }
        return sInstance;
    }

    void startAllPlugins() {
        for (Plugin plugin : this.plugins) {
            plugin.start();
        }
    }

    public void stopAllPlugins() {
        for (Plugin plugin : this.plugins) {
            plugin.stop();
        }
    }

    public void destroyAllPlugins() {
        for (Plugin plugin : this.plugins) {
            plugin.destroy();
        }
    }

    public Plugin getPluginByTag(String tag) {
        for (Plugin plugin : this.plugins) {
            if (!plugin.getTag().equals(tag)) continue;
            return plugin;
        }
        return null;
    }

    public <T extends Plugin> T getPluginByClass(Class<T> pluginClass) {
        String className = pluginClass.getName();
        for (Plugin plugin : this.plugins) {
            if (!plugin.getClass().getName().equals(className)) continue;
            return (T)plugin;
        }
        return null;
    }

    static class Builder {
        private OrionBaseCore mCore;
        private ConcurrentLinkedQueue<Plugin> plugins = new ConcurrentLinkedQueue();

        Builder(Context context) {
            if (context == null) {
                throw new RuntimeException("matrix init, application is null");
            }
            this.mCore = new OrionBaseCore(context);
            OrionBaseCore.init(this.mCore);
        }

        Builder plugin(Plugin plugin) {
            String tag = plugin.getTag();
            for (Plugin exist : this.plugins) {
                if (!tag.equals(exist.getTag())) continue;
                throw new RuntimeException(String.format("plugin with tag %s is already exist", tag));
            }
            this.plugins.add(plugin);
            return this;
        }

        Builder clientId(String clientId) {
            LocalUtils.setClientId(clientId);
            return this;
        }

        OrionBaseCore build() {
            this.mCore.build(this.plugins);
            return this.mCore;
        }
    }
}

