/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base;

import android.util.Log;
import com.ainirobot.base.config.Constants;
import com.ainirobot.base.util.Logger;

public final class AnalyticsConfig {
    public static long TIMING_REPORT_INTERVAL = Logger.debuggable() ? 60000L : 180000L;
    public static int EXPIRED_STAMP = Logger.debuggable() ? 300000 : 604800000;
    public static final String TAG = "OBAnalytics";
    public static final String TABLE_NAME = "table_name";
    public static final String DATA_LIST_NAME = "business_field";
    private static final String HIVE_DOMAIN_TEST = "http://recv-bi.ainirobot.com";
    private static final String HIVE_DOMAIN_FORMAL = "https://recv-bi.ainirobot.com";
    private static final String ENCRYPT_REPORTS_URL = "https://recv-bi.ainirobot.com/post/json/last/zip";
    private static final String REPORTS_URL_TEST = "http://recv-bi.ainirobot.com/post/json/last/zip";
    private static final String HIVE_DOMAIN_GLOBAL_TEST = "https://dev-recv-bi.ainirobot.com";
    private static String HIVE_DOMAIN_FORMAL_GLOBAL = "https://global-recv-bi.orionstar.com";
    private static final String ENCRYPT_REPORTS_URL_GLOBAL = HIVE_DOMAIN_FORMAL_GLOBAL + "/post/json/last/zip";
    private static final String REPORTS_URL_GLOBAL_TEST = "https://dev-recv-bi.ainirobot.com/post/json/last/zip";
    private static String HIVE_DOMAIN_FORMAL_US = "https://us-recv-bi.orionstar.com";
    public static final String KEY_CORP_UUID = "corp_uuid";
    public static final String KEY_APP_VERSION = "app_version";
    public static final String KEY_APP_NAME = "app_name";
    public static final String KEY_APP_PACKAGE = "app_package";
    public static final String KEY_SDK_VERSION = "sdk_version";
    public static final String KEY_TYPE = "type";
    public static final String KEY_CTIME = "ctime";
    public static final String KEY_LOGEVENT = "logevent";
    public static final String KTV_TABLE_NAME = "gb_orionbase_logevent";

    public static String getReportUrl() {
        if (Constants.BUILD_TYPE_UNIT_TEST) {
            if (Constants.ENABLE_DOMAIN_GLOBAL) {
                return REPORTS_URL_GLOBAL_TEST;
            }
            return REPORTS_URL_TEST;
        }
        if (Constants.ENABLE_DOMAIN_GLOBAL) {
            return AnalyticsConfig.getReportUrlGlobal();
        }
        return ENCRYPT_REPORTS_URL;
    }

    public static String getReportUrlGlobal() {
        String url = ENCRYPT_REPORTS_URL_GLOBAL;
        switch (Constants.GLOBAL_ZONE) {
            case "us": {
                url = HIVE_DOMAIN_FORMAL_US + "/post/json/last/zip";
            }
        }
        Log.d((String)TAG, (String)("getReportUrlGlobal: " + url));
        return url;
    }

    public static void processCloudServerByZone() {
        switch (Constants.GLOBAL_ZONE) {
            case "us": {
                HIVE_DOMAIN_FORMAL_GLOBAL = HIVE_DOMAIN_FORMAL_US;
            }
        }
        Log.d((String)TAG, (String)("HIVE_DOMAIN_FORMAL_GLOBAL: " + HIVE_DOMAIN_FORMAL_GLOBAL));
    }
}

