/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.ainirobot.base.AnalyticsApplicationWrapper;
import com.ainirobot.base.AnalyticsConfig;
import com.ainirobot.base.analytics.controller.AnalyticsController;
import com.ainirobot.base.analytics.interfaces.IAnalyticsConfig;
import com.ainirobot.base.analytics.interfaces.OnReportResultListener;
import com.ainirobot.base.analytics.utils.PublicDataUtils;
import com.ainirobot.base.util.LocalUtils;

public class AiniRobotAnalytics {
    private AnalyticsController analyticsController;

    private AiniRobotAnalytics() {
    }

    public static AiniRobotAnalytics getInstance() {
        return AiniRobotAnalyticHolder.INSTANCE;
    }

    public static void init(Context context, long reportDuration, IAnalyticsConfig config) {
        AnalyticsApplicationWrapper.setApplicationContext(context);
        PublicDataUtils.preparePublicData(context, config);
        AnalyticsConfig.TIMING_REPORT_INTERVAL = reportDuration;
        AiniRobotAnalytics.getInstance().analyticsController = new AnalyticsController(context);
    }

    public void setOnReportResultListener(OnReportResultListener onReportResultListener) {
        if (this.analyticsController != null) {
            this.analyticsController.setOnReportResultListener(onReportResultListener);
        } else {
            Log.i((String)"OBAnalytics", (String)"setOnReportResultListener, analyticsController is null");
        }
    }

    public void logEvent(String tableName, String dataString) {
        this.logEvent(tableName, dataString, false);
    }

    public void logEvent(String tableName, Bundle bundle) {
        this.logEvent(tableName, bundle, false);
    }

    public void logKTVEvent(String data, boolean isForce) {
        if (this.analyticsController != null) {
            Bundle bundle = new Bundle();
            bundle.putString("logevent", data);
            bundle.putString("corp_uuid", AiniRobotAnalytics.getSafeString(LocalUtils.getCorpUUID(AnalyticsApplicationWrapper.getApplicationContext())));
            bundle.putString("app_version", String.valueOf(LocalUtils.getVersionCode(AnalyticsApplicationWrapper.getApplicationContext())));
            bundle.putString("app_name", LocalUtils.getAppName(AnalyticsApplicationWrapper.getApplicationContext()));
            bundle.putString("app_package", LocalUtils.getPackageName(AnalyticsApplicationWrapper.getApplicationContext()));
            bundle.putString("sdk_version", AiniRobotAnalytics.getSafeString("2.0.5.0"));
            bundle.putInt("type", 1);
            bundle.putString("ctime", String.valueOf(System.currentTimeMillis()));
            this.analyticsController.addEvent("gb_orionbase_logevent", bundle, isForce);
        } else {
            Log.i((String)"OBAnalytics", (String)"logEvent(String tableName, Bundle bundle, boolean isForce), analyticsController is null");
        }
    }

    private static String getSafeString(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public void logEvent(String tableName, Bundle bundle, boolean isForce) {
        if (this.analyticsController != null) {
            this.analyticsController.addEvent(tableName, bundle, isForce);
        } else {
            Log.i((String)"OBAnalytics", (String)"logEvent(String tableName, Bundle bundle, boolean isForce), analyticsController is null");
        }
    }

    public void logEvent(String tableName, String dataString, boolean isForce) {
        if (this.analyticsController != null) {
            this.analyticsController.addEvent(tableName, dataString, isForce);
        } else {
            Log.i((String)"OBAnalytics", (String)"logEvent(String tableName, String dataString, boolean isForce), analyticsController is null");
        }
    }

    private static class AiniRobotAnalyticHolder {
        private static final AiniRobotAnalytics INSTANCE = new AiniRobotAnalytics();

        private AiniRobotAnalyticHolder() {
        }
    }
}

